function [tau_thresh, matrix, n_eco_func, start_day, end_day, ...
    n_ranges, firstCol, eco_names, spaces, n_chunks, eco_func_per_chunk, ...
    final_rows, func_choice] = get_func(julian_day)
disp(' ')
disp(' ')
disp('<<<<    Functionality Table    >>>>')
disp(' ')

%% Get the func_choice option
func_choice = 0;
while func_choice == 0
    
    disp('1. I want to use the compact default for salmon reproductive lifestage.')
    disp('      (includes Bed Occupation and Bed Preparation only)')
    disp('2. I want to use the full default for salmon reproductive lifestage.')
    disp('      (includes Spawning, Incubation, Emergence, and Bed Preparation)')
    disp('3. I want to enter my own custom Functionality Table.')
    disp(' ')

    func_choice = input('Please enter your choice, 1 through 3:  ');

    if func_choice ~= 1 && func_choice ~= 2 && func_choice ~= 3

        disp(' ')
        disp('Please enter a number from 1 to 3.')
        func_choice = 0;

    end

end

%% Case of compact default
if func_choice == 1

    n_ranges = 4;
    n_eco_func = 2;

    n_chunks = 1;

    eco_func_per_chunk = 2;

    tau_thresh = [0.1 0.06 0.03 0.01];

    firstCol = ['Julian Day     ';
        '0.06 < T < 0.10';
        '0.03 < T < 0.06';
        '0.01 < T < 0.03';
        '       T < 0.01';];

    matrix = [0 1; 0 1; 1 0; 0 0];

    spaces=70/n_eco_func;
    for i = 1:70
        spaces_vector(i) = [' '];
    end

    firstRow = ['                      Bed Occupation                    Bed Preparation         '];
    
    start_day = [1, 181];
    end_day = [180, 366];
    
    eco_names = [32,32,32,32,32,32,32,32,32,32,66,101,100,32,79,99,99,117,112,97,...
        116, 105, 111, 110,32,32,32,32,32,32,32,32,32,32;...
        32,32,32,32,32,32,32,32,32,32,66,101,100,32,80,114,101,112,97,114,...
        97,116,105,111,110,32,32,32,32,32,32,32,32,32];

    knuckle = find(firstRow ~= ' ');
    middle_knuckle = floor((knuckle(end)-knuckle(1))/2);
    titleRow = ['Range',spaces_vector(1,1:(middle_knuckle-10 + knuckle(1) - 5)),'Ecological Functions'];
    disp(' ')
    disp('This is the default compact functionality table you selected:')
    disp(' ')
    disp(' ')
    disp(titleRow)
    disp(firstRow)
    
    %putting in the julian day
    fprintf(firstCol(1,:))
    for j=1:n_eco_func
        for k=1:spaces/2-1-3
            fprintf(' ')
        end
        fprintf('%3.0f-%3.0f',start_day(j),end_day(j))
        for k=1:spaces/2-3
            fprintf(' ')
        end
    end %of j loop for n_eco_func
    fprintf('\n')
    
    %filling in the ones and zeros
    for i=1:n_ranges
        fprintf(firstCol(i+1,:))
        for j=1:n_eco_func
            for k=1:spaces/2-1
                fprintf(' ')
            end
            fprintf(num2str(matrix(i,j)))
            for k=1:spaces/2
                fprintf(' ')
            end
        end %of j loop for n_eco_func
        fprintf('\n')
    end %of i loop for n_ranges
    disp(' ')
    disp(' ')
    
    row_double = double(firstRow);
    for j = 1:length(row_double)
        final_rows(1,j) = row_double(j);
    end %j loop

end %choice == 1 if statement

%% Case of full default
if func_choice == 2

    n_ranges = 4;
    n_eco_func = 4;

    n_chunks = 1;

    eco_func_per_chunk = 4;

    tau_thresh = [0.1 0.06 0.03 0.01];

    firstCol = ['Julian Day     ';
        '0.06 < T < 0.10';
        '0.03 < T < 0.06';
        '0.01 < T < 0.03';
        '       T < 0.01';];

    matrix = [0 0 0 1; 0 0 0 1; 1 1 1 0; 1 0 1 0];

    spaces=70/n_eco_func;
    for i = 1:70
        spaces_vector(i) = ' ';
    end
    
    firstRow = '                  Spawning       Incubation       Emergence    Bed Preparation';
    
    start_day = [330, 330, 60, 181];
    end_day =  [90, 180, 180, 330];

    eco_names = [32    32    32    32    83   112    97   119   110   105   110   103    32    32    32    32;
                 32    32    32    73   110    99   117    98    97   116   105   111   110    32    32    32;
                 32    32    32    32    69   109   101   114   103   101   110    99   101    32    32    32;
                 32    66   101   100    32    80   114   101   112    97   114    97   116   105   111   110];

    knuckle = find(firstRow ~= ' ');
    middle_knuckle = floor((knuckle(end)-knuckle(1))/2);
    titleRow = ['Range',spaces_vector(1,1:(middle_knuckle-10 + knuckle(1) - 5)),'Ecological Functions'];
    disp(' ')
    disp('This is the default full functionality table you selected:')
    disp(' ')
    disp(' ')
    disp(titleRow)
    disp(firstRow)

    %putting in the julian day
    fprintf(firstCol(1,:))
    for j=1:n_eco_func
        for k=1:spaces/2-1-3
            fprintf(' ')
        end
        fprintf('%3.0f-%3.0f',start_day(j),end_day(j))
        for k=1:spaces/2-3
            fprintf(' ')
        end
    end %of j loop for n_eco_func
    fprintf('\n')
    
    %filling in the ones and zeros
    for i=1:n_ranges
        fprintf(firstCol(i+1,:))
        for j=1:n_eco_func
            for k=1:spaces/2-1
                fprintf(' ')
            end
            fprintf(num2str(matrix(i,j)))
            for k=1:spaces/2
                fprintf(' ')
            end
        end %of j loop for n_eco_func
        fprintf('\n')
    end %of i loop for n_ranges
    disp(' ')
    disp(' ')
    
    row_double = double(firstRow);
    for j = 1:length(row_double)
        final_rows(1,j) = row_double(j);
    end %j loop
    
end %choice == 2 if statement

%% Case of user specified custom table
if func_choice == 3
    
    years_end = 366;

    n_eco_func = 0;
    n_ranges = 0;

    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %Prompting the request for ranges of shear and number of eco func
    while n_ranges <= 0 | mod(n_ranges,1) ~= 0
        
        disp(' ')
        n_ranges = input('How many ranges do you want for nondimensional shear stress?  ');
        disp(' ')

        if n_ranges <= 0 | mod(n_ranges,1) ~= 0
            disp(' ')
            disp('Please enter a positive integer.')
            disp(' ')
            continue
        end %if

    end %while

    while n_eco_func <= 0 | mod(n_eco_func,1) ~= 0

        n_eco_func = input('How many ecological functions do you want to track?  ');
        disp(' ')

        if n_eco_func <= 0 | mod(n_eco_func,1) ~= 0
            disp(' ')
            disp('Please enter a positive integer.')
            disp(' ')
        end % if

    end % while

    n_chunks = ceil(n_eco_func/4);
    for i = 1:n_chunks
        if i < n_chunks | mod(n_eco_func,4) == 0
            eco_func_per_chunk(i) = 4;
        elseif i == n_chunks && mod(n_eco_func,4) ~= 0
            eco_func_per_chunk(i) = mod(n_eco_func,4);
        end
    end

    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Prompting the request for thresholds of shear
    i = 1;
    tau_thresh(i) = 0;
    while tau_thresh(i) <= 0
        disp(' ')
        tau_thresh(i) = input('Please enter the high threshold of the nondimensional shear stress:  ');
        disp(' ')

        if tau_thresh(i) <=0
            disp(' ')
            disp('Please enter a positive value.')
            disp(' ')
        end %if

    end %while

    % Case for n_ranges more than 2
    if n_ranges > 2

        for i = 2:n_ranges - 1
            tau_thresh(i) = 0;

            while tau_thresh(i) <= 0
                disp(' ')
                tau_thresh(i) = input('Please enter the next threshold of the nondimensional shear stress:  ');
                disp(' ')

                if tau_thresh(i) <=0
                    disp(' ')
                    disp('Please enter a positive value.')
                    disp(' ')
                end %if

            end %while

        end %i loop

    end

    % Case for 1 range
    if n_ranges == 1
        i = n_ranges + 1;
    else
        i = n_ranges;
    end

    tau_thresh(i) = 0;
    while tau_thresh(i) <= 0
        disp(' ')
        tau_thresh(i) = input('Please enter the low threshold of the nondimensional shear stress:  ');
        disp(' ')

        if tau_thresh(i) <=0
            disp(' ')
            disp('Please enter a positive value.')
            disp(' ')
        end %if

    end %while

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Finding the lenght of the first column
    if n_ranges > 1
        
        i=1;
        Len(i) = 10;
        
        for i = 2:n_ranges
            Len(i) = length([num2str(tau_thresh(i)),' < T < ',num2str(tau_thresh(i-1))]);
        end

        i = n_ranges + 1;
        Len(i) = length(['T < ',num2str(tau_thresh(i-1))]);

    end %if more than 1 range

    if n_ranges == 1

        i = 1;
        Len(i) = 10;
        i = 2;
        Len(i) = length([num2str(tau_thresh(i)),' < T < ',num2str(tau_thresh(i-1))]);

    end %if 1 range

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Filling the first columns
    % Case for more than one range
    if n_ranges > 1
        
        %the first line of firstCol -- Julian Day
        i = 1;
        if Len(i) < max(Len)
            temp = ' ';
            for k = 1:(max(Len) - Len(i))-1
                temp = [temp,' '];
            end %of k loop
            firstCol(i,:) = ['Julian Day',temp];
            clear temp
        else
            firstCol(i,:) = ['Julian Day'];
        end %of if statement
        
        %the middle ones
        for i = 2:n_ranges

            if Len(i) < max(Len)
                temp = ' ';
                for k = 1:(max(Len) - Len(i))-1
                    temp = [temp,' '];
                end %for k
                firstCol(i,:)=[num2str(tau_thresh(i)),' < T < ',num2str(tau_thresh(i-1)),temp];
                clear temp
            else
                firstCol(i,:)=[num2str(tau_thresh(i)),' < T < ',num2str(tau_thresh(i-1))];
            end %if

        end % for i

        i = n_ranges + 1;
        if Len(i) < max(Len)
            temp = [' '];
            for k = 1:(max(Len) - Len(i))-1
                temp = [temp,' '];
            end
            firstCol(i,:) = ['T < ',num2str(tau_thresh(i-1)),temp];
            clear temp
        else
            firstCol(i,:) = ['T < ',num2str(tau_thresh(i-1))];
        end %if

    end %if more than 1 range

    % Case for 1 range
    if n_ranges == 1
        
        i = 1;
        if Len(i) < max(Len)
            temp = ' ';
            for k = 1:(max(Len) - Len(i))-1
                temp = [temp,' '];
            end %of k loop
            firstCol(i,:) = ['Julian Day',temp];
            clear temp
        else
            firstCol(i,:) = ['Julian Day'];
        end %of if statement
        
        i = 2;
        if Len(i) < max(Len)
            temp = ' ';
            for k = 1:(max(Len) - Len(i))-1
                temp = [temp,' '];
            end %of k loop
            firstCol(i,:) = [num2str(tau_thresh(i)),' < T < ',num2str(tau_thresh(i-1)),temp];
            clear temp
        else
            firstCol(i,:) = [num2str(tau_thresh(i)),' < T < ',num2str(tau_thresh(i-1))];
        end %of if statement        

    end %if 1 range

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Formatting and naming

    for m = 1:n_chunks

        spaces(m)=70/eco_func_per_chunk(m); %spaces=70/n_eco_func;

        firstRow=[''];

        %This big i loop needs to go from i_start:i_end not 1:n_eco_func
        for i = (1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))        %1:n_eco_func
            disp(' ')
            disp(' ')
            fprintf('Please enter the name of ecological funciton number %0.0f',i)
            %Read the name in as a string.
            eco_name_string = input(':  ','s');

            start_day(i) = 0;
            while start_day(i) <= 0 | start_day(i) > years_end | mod(start_day,1) ~= 0
                disp(' ')
                fprintf('Please enter the starting Julian Day of %s:  ',eco_name_string);                
                start_day(i) = input('');

                if start_day(i) <= 0 | start_day(i) > years_end | mod(start_day,1) ~= 0
                    disp(' ')
                    fprintf('Please enter an integer between 1 and %0.0f for the starting Julian Day.', years_end)
                    disp(' ')
                end
            end

            end_day(i) = 0;
            while end_day(i) <= 0 | end_day(i) > years_end | mod(end_day,1) ~= 0
                disp(' ')
                fprintf('Please enter the ending Julian Day of %s:  ',eco_name_string);                
                end_day(i) = input('');

                if end_day(i) <= 0 | end_day(i) > years_end | mod(end_day,1) ~= 0
                    disp(' ')
                    fprintf('Please enter an integer between 1 and %0.0f for the ending Julian Day.', years_end)
                    disp(' ')
                end
                
                if end_day(i) == start_day(i)
                    disp(' ')
                    disp(' ')
                    disp('Each ecological function must last at least 1 day.')
                    disp(' ')
                    end_day(i) = -1;
                end
            end

            temp=[' '];
            for j=1:floor(70/eco_func_per_chunk(m)-length(eco_name_string))/2-1
                temp=[temp,' '] ;
            end

            eco_name_string=[temp,eco_name_string];
            for k=1:spaces(m)-length(eco_name_string)-1
                eco_name_string(end+1)=[' '];
            end

            firstRow=[' ',firstRow,eco_name_string];

            %This still works, needs no fixing
            %Convert the string to a vector of numbers.
            eco_name_double = double(eco_name_string);

            %Save these vectors of numbers into one matrix which can be
            %converted back to strings later.
            for j = 1:length(eco_name_double)
                eco_names(i,j) = eco_name_double(j);
            end % j loop

        end % i loop

        row_double = double(firstRow);
        for j = 1:length(row_double)
            rows(m,j) = row_double(j);
        end
        clear firstRow
        clear temp
    end %m loop

    temp = ones(1,(max(Len)-5))*32;

    for m = 1:n_chunks
        for j = 1:length(rows) + length(temp)
            if j <= length(temp)
                final_rows(m,j) = temp(j);
            else
                final_rows(m,j) = rows(m,j-length(temp));
            end %if
        end %j loop
    end %m loop

    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %Getting the actual functionality

    disp(' ')
    disp('The functionality must be input as a Matlab vector, i.e. [1 0 0 1], INCLUDING the brackets,')
    disp('  where: 1 = Functional,  0 = Non-functional.')
    fprintf('Since you have %0.0f ecological functions, you will need %0.0f entries in each vector.',...
        n_eco_func,n_eco_func)
    fprintf('\nThe row numbers start at 1, representing the highest range, and end at %0.0f, representing the lowest range.',n_ranges)
    disp(' ')

    for i=1:n_ranges

        flagg(i) = 0;

        while flagg(i) == 0

            fprintf('Please enter the functionality for row number %0.0f:  ',i)
            test = input(' ');

            if length(test) ~= n_eco_func
                disp(' ')
                fprintf('Please enter %0.0f entries in each row.\n',n_eco_func)
                flagg(i) = 0;
                continue
            end %if

            for j = 1:length(test)
                if test(j) == 1 | test(j) == 0
                    keep_going(j) = 1;
                else
                    keep_going(j) = 0;
                end %if
            end %j loop

            if sum(keep_going) == length(test)
                flagg(i) = 1;
                matrix(i,:) = test;
            else
                disp(' ')
                disp('Please enter only 1''s for functional and 0''s for non-functional in the vector.')
                flagg(i) = 0;                
            end %if
            
        end %while
    end %i loop

    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %Displaying the results

    for i = 1:70
        spaces_vector(i) = [' '];
    end

    disp(' ')
    disp('This is the custom functionality table you entered:')
    disp(' ')
    disp(' ')

    for m = 1:n_chunks

        if m > 1
            disp('Functionality Table (continued)')
        end

        knuckle = find(char(final_rows(m,:)) ~= ' ');
        middle_knuckle = floor((knuckle(end)-knuckle(1))/2);
        titleRow = ['Ranges',spaces_vector(1,1:(middle_knuckle-10 + knuckle(1) - 5)),'Ecological Functions'];
        disp(titleRow)
        disp(char(final_rows(m,:)))
        
        %displaying the julian days
        i = 1;
        fprintf(firstCol(i,:))
        for j=(1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))
            for k=1:spaces(m)/2-1-3
                fprintf(' ')
            end
            fprintf('%3.0f-%3.0f',start_day(j),end_day(j))
            for k=1:spaces(m)/2-3
                fprintf(' ')
            end
        end
        fprintf('\n')
        
        %displaying the 1's and 0's
        for i=1:n_ranges
            fprintf(firstCol(i+1,:))
            for j=(1 + sum(eco_func_per_chunk(1:m-1))):sum(eco_func_per_chunk(1:m))
                for k=1:spaces(m)/2-1
                    fprintf(' ')
                end
                fprintf(num2str(matrix(i,j)))
                for k=1:spaces(m)/2
                    fprintf(' ')
                end
            end
            fprintf('\n')
        end %i loop
        disp(' ')
        disp(' ')
    end %m loop
    
    %format eco_names vector correctly
    size_of_eco_names = size(eco_names);
    for i = 1:size_of_eco_names(1)
        for j = 1:size_of_eco_names(2)
            if eco_names(i,j) == 0
                eco_names(i,j) = 32;
            end
        end
    end
    
end %choice == 3 if statement